---
title: PDF to Word Command Line Conversion
platform: Windows
metaTitle: "PDF to Word Command Line | PDFTron"
---

PDFTron's **PDF2Word** is an easy-to-use, stand-alone command-line application that
provides users with an efficient means of converting PDF documents to Microsoft Word
and RTF formats. PDF2Word exports high quality DOCX, DOC and RTF that preserve the
structure and look-and-feel of the original PDF.

**Like other PDFTron products, PDF2Word does not rely on any other
third-party software. PDF2Word can be used in server environments or as
a batch conversion process.**

<a class="Button medium" href="https://www.pdftron.com/documentation/cli/download/windows/" >Download PDF2Word</a>

## Why PDF2Word?

PDF2Word is easy to use and reliably preserves the PDF files' fonts, paragraphs, lists, tables and columns in the Word output. PDF fonts are mapped to the appropriate Word fonts with style, size and kerning to make accurate fit. PDF tables with and without PDF table structures are detected and converted to Word tables automatically. Single and multi-column pages are converted to equivalent structures with text flow preserved to facilitate editing. Lists are detected and converted automatically to lists in Word. Graphics are converted authentically and placed accurately on the page. Fonts and formatting are adjusted to make PDF page content fit on a single page.

PDF2Word can be used in server environments and is also suitable for use in batch conversion workflows.

## **Key Functions**

-   Convert PDF to DOCX, DOC and RTF.

-   Support for all versions of Acrobat documents.

-   Support for Unicode and all PDF font formats.

-   Support for password-protected PDF.

-   Batch conversion.

-   Faithfully preserves the PDF's look-&-feel.

-   Automatically converts to structured content.

-   Option to convert specific page ranges.

-   Option to generate bookmarks.

-   Options to control image quality.

-   Options to handle OCRed PDFs.

## **Common Use Case Scenarios**

-   Simple conversion of PDF to Word to edit document.

-   Server-based, on-demand conversion of PDF documents to Word format.

-   Batch processing of PDF collections with the same conversion options.

## **Operating Systems Supported**

-   Windows, Linux and Mac.

## **System Requirements**

-   At least 30 MB of free disk space.

-   Memory requirement is dependent on the source document being converted. We recommend a minimum of 4 GB.

## Example

```
pdf2word -in input.pdf -out output.docx
```
