---
title: Frequently Asked Questions
metaTitle: Frequently Asked Questions for PDF2Word | PDFTron CLI
---

### Is PDF2Word available as an SDK for integration with third party applications?

For developers who are looking for a software development component to integrate
into their applications, PDFTron offers a PDF to Word conversion API.

For more details, please vist [www.pdftron.com](https://www.pdftron.com/) or
contact a [PDFTron representative](https://www.pdftron.com/company/contact-us/) for more information.

### Does PDF2Word have any dependencies on third party components/software?

PDF2Word is a completely stand-alone application and does not include any
dependencies on third-party components or software.

### How do I save converted files in a given folder?

To specify an output location, use the '-out' (or '-o') parameter with
an absolute file name. For example:

`pdf2word -in myIn.pdf -out "~/My Output/myOut.docx"`

### How do I specify which pages to convert?

By default, PDF2Word will convert all PDF pages into an output DOCX, DOC or RTF file.
You can specify a subset of pages to convert using the '-pages' option. For example:

`pdf2word -pages 2 -in in.pdf -out output.docx`

will convert only page 2.

To specify a range of pages, use a dash character between numbers. For example:

`pdf2word -pages 1-3 -in in.pdf -out output.docx`

will convert pages 1 to 3.

### How do I batch convert files?

PDF2Word supports batch conversion of many PDF files in a single pass. For example,
to convert three PDFs, a.pdf, b.pdf and c.pdf, to a.docx, b.doc and c.rtf, you could
use the following line:

`pdf2word -in a.pdf b.pdf c.pdf -out a.docx b.doc c.rtf`

The number of input file names must match the number of output file names.

### How do I convert to a specific output file type?

You can convert PDF to DOCX, DOC or RTF by specifying the output file type as the
file extension of the output file name, i.e. .docx, .doc or .rtf. For example,
to convert to RTF, you can use the following syntax:

`pdf2word -in indoc.pdf -out outdoc.rtf`

Alternatively, you can also set the output file type by using the '-output' parameter
with 'docx', 'doc' or 'rtf'. The following command-line would generate the output RTF
as output.tmp:

`pdf2word -output rtf -in mydoc.pdf -out output.tmp`

By default, PDF2Word will convert PDF files to DOCX files.

### How do I convert a password protected PDF?

PDF2Word will, without user intervention, convert documents secured with a master/owner password.

For unattended conversion, specify the master/owner password directly on the command-line
using the '-password' parameter option. The password provided must give unrestricted
content extraction permissions. For example, to convert a password protected secured.pdf
with the master password, 'secret', use the following syntax:

`pdf2word -password secret -in secured.pdf -out secured.docx`
