@echo off
@echo Command-line samples for PDFSecure
@echo Copyright 2001-2025 Apryse Software Inc.
@echo.
@echo Example 1) Securing a single PDF document using 128 bit RC4 encryption and user (open) password:
pdfsecure -o test_out/ex1/blue_secret.pdf -s 128 -u secret test/blue.pdf
@echo.
@echo Example 2) Securing a folder of PDF documents using AES encryption and user (open) password:
pdfsecure -o test_out/ex2 -s AES -u secret test
@echo.
@echo Example 2b) Securing a folder of PDF documents using PDFTron Custom encryption with a custom id  and user (open) password:
pdfsecure -o test_out/ex2_custom -s custom -c 123456789 -u secret test
@echo.
@echo Example 3) Securing a file with a user (open) and an owner (permission) password and setting permissions:
pdfsecure -o test_out/ex3/r1.pdf -s 128 -u userpass -w ownerpass -d a test/red.pdf
@echo.
@echo Example 4) Setting permissions:
pdfsecure -o test_out/ex4 -s 128 -w foo -d mcofxs -e ph --subfolders test
pdfsecure -o test_out/ex4/out2.pdf -s 128 -w foo -d ms -e cox test/red.pdf
@echo.
@echo Example 5) Removing Security:
pdfsecure -o test_out/ex5 -s R test test_out/ex4/out2.pdf
pdfsecure -o test_out/ex5 -s R test test_out/ex4
pdfsecure -o test_out/ex5/ex3r1.pdf -s R -p userpass test_out/ex3/r1.pdf
pdfsecure -o test_out/ex5 -s R -p secret test_out/ex2/test --subfolders
pdfsecure -o test_out/ex5/e1.pdf -s R -p secret test_out/ex1/blue_secret.pdf
pdfsecure -o test_out/ex5_rm_custom -s R -c 123456789 -p secret test_out/ex2_custom/test
@echo.
@echo Example 6) Modifying document information metadata:
pdfsecure -o test_out/ex6 --title "My Title" --subject "My Subject" --creator "Source App" --producer "PDF Secure" --author "Joe Doe" --keywords "key1 key2 key3" test
@echo.
@echo Example 7) PDF Linearization (Fast Web View Enabling):
pdfsecure -o test_out/ex7 -l test_out/ex6/test
@echo.
@echo Example 8) Combining different operations:
pdfsecure -o test_out/ex8 -l --title "My Title" --subject "My Subject" --creator "Source App" --producer "PDF Secure" --author "Joe Doe" --keywords "key1 key2 key3" -s AES -u userpass -w ownerpass -d chsmx -e of test
@echo.